"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const proxy_factory_1 = require("@theia/core/lib/common/messaging/proxy-factory");
const electron_main_window_service_1 = require("@theia/core/lib/electron-common/electron-main-window-service");
const electron_connection_handler_1 = require("@theia/core/lib/electron-common/messaging/electron-connection-handler");
const electron_main_application_1 = require("@theia/core/lib/electron-main/electron-main-application");
const theia_electron_window_1 = require("@theia/core/lib/electron-main/theia-electron-window");
const inversify_1 = require("@theia/core/shared/inversify");
const ide_updater_1 = require("../common/protocol/ide-updater");
const electron_main_window_service_ext_1 = require("../electron-common/electron-main-window-service-ext");
const is_temp_sketch_1 = require("../node/is-temp-sketch");
const electron_main_window_service_ext_impl_1 = require("./electron-main-window-service-ext-impl");
const ide_updater_impl_1 = require("./ide-updater/ide-updater-impl");
const electron_main_application_2 = require("./theia/electron-main-application");
const electron_main_window_service_2 = require("./theia/electron-main-window-service");
const theia_electron_window_2 = require("./theia/theia-electron-window");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(electron_main_application_2.ElectronMainApplication).toSelf().inSingletonScope();
    rebind(electron_main_application_1.ElectronMainApplication).toService(electron_main_application_2.ElectronMainApplication);
    bind(electron_main_window_service_2.ElectronMainWindowServiceImpl).toSelf().inSingletonScope();
    rebind(electron_main_window_service_1.ElectronMainWindowService).toService(electron_main_window_service_2.ElectronMainWindowServiceImpl);
    // IDE updater bindings
    bind(ide_updater_impl_1.IDEUpdaterImpl).toSelf().inSingletonScope();
    bind(ide_updater_1.IDEUpdater).toService(ide_updater_impl_1.IDEUpdaterImpl);
    bind(electron_main_application_1.ElectronMainApplicationContribution).toService(ide_updater_1.IDEUpdater);
    bind(electron_connection_handler_1.ElectronConnectionHandler)
        .toDynamicValue((context) => new proxy_factory_1.JsonRpcConnectionHandler(ide_updater_1.IDEUpdaterPath, (client) => {
        const server = context.container.get(ide_updater_1.IDEUpdater);
        server.setClient(client);
        client.onDidCloseConnection(() => server.disconnectClient(client));
        return server;
    }))
        .inSingletonScope();
    bind(theia_electron_window_2.TheiaElectronWindow).toSelf();
    rebind(theia_electron_window_1.TheiaElectronWindow).toService(theia_electron_window_2.TheiaElectronWindow);
    bind(electron_main_window_service_ext_1.ElectronMainWindowServiceExt)
        .to(electron_main_window_service_ext_impl_1.ElectronMainWindowServiceExtImpl)
        .inSingletonScope();
    bind(electron_connection_handler_1.ElectronConnectionHandler)
        .toDynamicValue((context) => new proxy_factory_1.JsonRpcConnectionHandler(electron_main_window_service_ext_1.electronMainWindowServiceExtPath, () => context.container.get(electron_main_window_service_ext_1.ElectronMainWindowServiceExt)))
        .inSingletonScope();
    bind(is_temp_sketch_1.IsTempSketch).toSelf().inSingletonScope();
});
//# sourceMappingURL=arduino-electron-main-module.js.map