"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TheiaElectronWindow = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const electron_1 = require("@theia/electron/shared/electron");
const electron_messages_1 = require("@theia/core/lib/electron-common/messaging/electron-messages");
const theia_electron_window_1 = require("@theia/core/lib/electron-main/theia-electron-window");
const node_1 = require("@theia/core/lib/node");
const uri_1 = require("@theia/core/lib/common/uri");
const event_utils_1 = require("@theia/core/lib/electron-main/event-utils");
const electron_messages_2 = require("@theia/core/lib/electron-common/messaging/electron-messages");
let TheiaElectronWindow = class TheiaElectronWindow extends theia_electron_window_1.TheiaElectronWindow {
    async handleStopRequest(onSafeCallback, reason) {
        // Only confirm close to windows that have loaded our frontend.
        // Both the windows's URL and the FS path of the `index.html` should be converted to the "same" format to be able to compare them. (#11226)
        // Notes:
        //  - Windows: file:///C:/path/to/somewhere vs file:///c%3A/path/to/somewhere
        //  - macOS: file:///Applications/App%20Name.app/Contents vs /Applications/App Name.app/Contents
        // This URL string comes from electron, we can expect that this is properly encoded URL. For example, a space is `%20`
        const currentUrl = new uri_1.default(this.window.webContents.getURL()).toString();
        // THEIA_FRONTEND_HTML_PATH is an FS path, we have to covert to an encoded URI string.
        const frontendUri = node_1.FileUri.create(this.globals.THEIA_FRONTEND_HTML_PATH).toString();
        const safeToClose = !currentUrl.includes(frontendUri) || (await this.checkSafeToStop(reason));
        if (safeToClose) {
            try {
                await onSafeCallback();
                return true;
            }
            catch (e) {
                console.warn(`Request ${electron_messages_1.StopReason[reason]} failed.`, e);
            }
        }
        return false;
    }
    // Note: does the same as the Theia impl, but logs state changes.
    trackApplicationState() {
        (0, event_utils_1.createDisposableListener)(electron_1.ipcMain, electron_messages_2.APPLICATION_STATE_CHANGE_SIGNAL, (e, state) => {
            console.log('app-state-change', `>>> new app state <${state} was received from sender <${e.sender.id}>. current window ID: ${this._window.id}`);
            if (this.isSender(e)) {
                this.applicationState = state;
                console.log('app-state-change', `<<< new app state is <${this.applicationState}> for window <${this._window.id}>`);
            }
            else {
                console.log('app-state-change', `<<< new app state <${state}> is ignored from <${e.sender.id}>. current window ID is <${this._window.id}>`);
            }
        }, this.toDispose);
    }
};
TheiaElectronWindow = __decorate([
    (0, inversify_1.injectable)()
], TheiaElectronWindow);
exports.TheiaElectronWindow = TheiaElectronWindow;
//# sourceMappingURL=theia-electron-window.js.map