"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArduinoFirmwareUploaderImpl = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const protocol_1 = require("../common/protocol");
const exec_util_1 = require("./exec-util");
const logger_1 = require("@theia/core/lib/common/logger");
const monitor_manager_1 = require("./monitor-manager");
let ArduinoFirmwareUploaderImpl = class ArduinoFirmwareUploaderImpl {
    onError(error) {
        this.logger.error(error);
    }
    async getExecPath() {
        if (this._execPath) {
            return this._execPath;
        }
        this._execPath = await (0, exec_util_1.getExecPath)('arduino-fwuploader');
        return this._execPath;
    }
    async runCommand(args) {
        const execPath = await this.getExecPath();
        return await (0, exec_util_1.spawnCommand)(`"${execPath}"`, args, this.onError.bind(this));
    }
    async uploadCertificates(command) {
        return await this.runCommand(['certificates', 'flash', command]);
    }
    async list(fqbn) {
        const fqbnFlag = fqbn ? ['--fqbn', fqbn] : [];
        const firmwares = JSON.parse(await this.runCommand([
            'firmware',
            'list',
            ...fqbnFlag,
            '--format',
            'json',
        ])) || [];
        return firmwares.reverse();
    }
    async updatableBoards() {
        return (await this.list()).reduce((a, b) => (a.includes(b.board_fqbn) ? a : [...a, b.board_fqbn]), []);
    }
    async availableFirmwares(fqbn) {
        return await this.list(fqbn);
    }
    async flash(firmware, port) {
        let output;
        const board = {
            name: firmware.board_name,
            fqbn: firmware.board_fqbn,
        };
        try {
            await this.monitorManager.notifyUploadStarted(board.fqbn, port);
            output = await this.runCommand([
                'firmware',
                'flash',
                '--fqbn',
                firmware.board_fqbn,
                '--address',
                port.address,
                '--module',
                `${firmware.module}@${firmware.firmware_version}`,
            ]);
        }
        catch (e) {
            throw e;
        }
        finally {
            await this.monitorManager.notifyUploadFinished(board.fqbn, port);
            return output;
        }
    }
};
__decorate([
    (0, inversify_1.inject)(protocol_1.ExecutableService),
    __metadata("design:type", Object)
], ArduinoFirmwareUploaderImpl.prototype, "executableService", void 0);
__decorate([
    (0, inversify_1.inject)(logger_1.ILogger),
    (0, inversify_1.named)('fwuploader'),
    __metadata("design:type", Object)
], ArduinoFirmwareUploaderImpl.prototype, "logger", void 0);
__decorate([
    (0, inversify_1.inject)(monitor_manager_1.MonitorManager),
    __metadata("design:type", monitor_manager_1.MonitorManager)
], ArduinoFirmwareUploaderImpl.prototype, "monitorManager", void 0);
ArduinoFirmwareUploaderImpl = __decorate([
    (0, inversify_1.injectable)()
], ArduinoFirmwareUploaderImpl);
exports.ArduinoFirmwareUploaderImpl = ArduinoFirmwareUploaderImpl;
//# sourceMappingURL=arduino-firmware-uploader-impl.js.map