"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("@theia/core/shared/inversify");
const arduino_daemon_impl_1 = require("./arduino-daemon-impl");
const arduino_firmware_uploader_1 = require("../common/protocol/arduino-firmware-uploader");
const logger_1 = require("@theia/core/lib/common/logger");
const backend_application_1 = require("@theia/core/lib/node/backend-application");
const library_service_1 = require("../common/protocol/library-service");
const boards_service_1 = require("../common/protocol/boards-service");
const library_service_impl_1 = require("./library-service-impl");
const boards_service_impl_1 = require("./boards-service-impl");
const core_service_impl_1 = require("./core-service-impl");
const core_service_1 = require("../common/protocol/core-service");
const connection_container_module_1 = require("@theia/core/lib/node/messaging/connection-container-module");
const core_client_provider_1 = require("./core-client-provider");
const core_1 = require("@theia/core");
const default_workspace_server_1 = require("./theia/workspace/default-workspace-server");
const common_1 = require("@theia/workspace/lib/common");
const sketches_service_impl_1 = require("./sketches-service-impl");
const sketches_service_1 = require("../common/protocol/sketches-service");
const config_service_1 = require("../common/protocol/config-service");
const arduino_daemon_1 = require("../common/protocol/arduino-daemon");
const config_service_impl_1 = require("./config-service-impl");
const env_variables_1 = require("@theia/core/lib/common/env-variables");
const env_variables_server_1 = require("./theia/env-variables/env-variables-server");
const node_filesystem_ext_1 = require("./node-filesystem-ext");
const filesystem_ext_1 = require("../common/protocol/filesystem-ext");
const examples_service_impl_1 = require("./examples-service-impl");
const examples_service_1 = require("../common/protocol/examples-service");
const executable_service_1 = require("../common/protocol/executable-service");
const executable_service_impl_1 = require("./executable-service-impl");
const response_service_1 = require("../common/protocol/response-service");
const notification_service_server_1 = require("./notification-service-server");
const protocol_1 = require("../common/protocol");
const backend_application_2 = require("./theia/core/backend-application");
const board_discovery_1 = require("./board-discovery");
const authentication_service_impl_1 = require("./auth/authentication-service-impl");
const authentication_service_1 = require("../common/protocol/authentication-service");
const arduino_firmware_uploader_impl_1 = require("./arduino-firmware-uploader-impl");
const plotter_backend_contribution_1 = require("./plotter/plotter-backend-contribution");
const arduino_localization_contribution_1 = require("./i18n/arduino-localization-contribution");
const localization_contribution_1 = require("@theia/core/lib/node/i18n/localization-contribution");
const monitor_manager_proxy_impl_1 = require("./monitor-manager-proxy-impl");
const monitor_manager_1 = require("./monitor-manager");
const monitor_service_1 = require("../common/protocol/monitor-service");
const monitor_service_2 = require("./monitor-service");
const monitor_settings_provider_1 = require("./monitor-settings/monitor-settings-provider");
const monitor_settings_provider_impl_1 = require("./monitor-settings/monitor-settings-provider-impl");
const monitor_service_factory_1 = require("./monitor-service-factory");
const web_socket_provider_impl_1 = require("./web-socket/web-socket-provider-impl");
const web_socket_provider_1 = require("./web-socket/web-socket-provider");
const clang_formatter_1 = require("./clang-formatter");
const formatter_1 = require("../common/protocol/formatter");
const localization_backend_contribution_1 = require("./i18n/localization-backend-contribution");
const localization_backend_contribution_2 = require("@theia/core/lib/node/i18n/localization-backend-contribution");
const survey_service_impl_1 = require("./survey-service-impl");
const survey_service_1 = require("../common/protocol/survey-service");
const is_temp_sketch_1 = require("./is-temp-sketch");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(backend_application_2.BackendApplication).toSelf().inSingletonScope();
    rebind(backend_application_1.BackendApplication).toService(backend_application_2.BackendApplication);
    // Shared config service
    bind(config_service_impl_1.ConfigServiceImpl).toSelf().inSingletonScope();
    bind(config_service_1.ConfigService).toService(config_service_impl_1.ConfigServiceImpl);
    // Note: The config service must start earlier than the daemon, hence the binding order of the BA contribution does matter.
    bind(backend_application_1.BackendApplicationContribution).toService(config_service_impl_1.ConfigServiceImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(config_service_1.ConfigServicePath, () => context.container.get(config_service_1.ConfigService)))
        .inSingletonScope();
    // Shared daemon
    bind(arduino_daemon_impl_1.ArduinoDaemonImpl).toSelf().inSingletonScope();
    bind(arduino_daemon_1.ArduinoDaemon).toService(arduino_daemon_impl_1.ArduinoDaemonImpl);
    bind(backend_application_1.BackendApplicationContribution).toService(arduino_daemon_impl_1.ArduinoDaemonImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(arduino_daemon_1.ArduinoDaemonPath, () => context.container.get(arduino_daemon_1.ArduinoDaemon)))
        .inSingletonScope();
    // Shared formatter
    bind(clang_formatter_1.ClangFormatter).toSelf().inSingletonScope();
    bind(core_1.ConnectionHandler)
        .toDynamicValue(({ container }) => new core_1.JsonRpcConnectionHandler(formatter_1.FormatterPath, () => container.get(clang_formatter_1.ClangFormatter)))
        .inSingletonScope();
    // Built-in examples are not board specific, so it is possible to have one shared instance.
    bind(examples_service_impl_1.BuiltInExamplesServiceImpl).toSelf().inSingletonScope();
    // Examples service. One per backend, each connected FE gets a proxy.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(examples_service_impl_1.ExamplesServiceImpl).toSelf().inSingletonScope();
        bind(examples_service_1.ExamplesService).toService(examples_service_impl_1.ExamplesServiceImpl);
        bindBackendService(examples_service_1.ExamplesServicePath, examples_service_1.ExamplesService);
    }));
    // Exposes the executable paths/URIs to the frontend
    bind(executable_service_impl_1.ExecutableServiceImpl).toSelf().inSingletonScope();
    bind(executable_service_1.ExecutableService).toService(executable_service_impl_1.ExecutableServiceImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(executable_service_1.ExecutableServicePath, () => context.container.get(executable_service_1.ExecutableService)))
        .inSingletonScope();
    // Library service. Singleton per backend, each connected FE gets its proxy.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(library_service_impl_1.LibraryServiceImpl).toSelf().inSingletonScope();
        bind(library_service_1.LibraryService).toService(library_service_impl_1.LibraryServiceImpl);
        bindBackendService(library_service_1.LibraryServicePath, library_service_1.LibraryService);
    }));
    // Shared sketches service
    bind(sketches_service_impl_1.SketchesServiceImpl).toSelf().inSingletonScope();
    bind(sketches_service_1.SketchesService).toService(sketches_service_impl_1.SketchesServiceImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(sketches_service_1.SketchesServicePath, () => context.container.get(sketches_service_1.SketchesService)))
        .inSingletonScope();
    // Boards service. One instance per connected frontend.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(boards_service_impl_1.BoardsServiceImpl).toSelf().inSingletonScope();
        bind(boards_service_1.BoardsService).toService(boards_service_impl_1.BoardsServiceImpl);
        bindBackendService(boards_service_1.BoardsServicePath, boards_service_1.BoardsService);
    }));
    // Shared Arduino core client provider service for the backend.
    bind(core_client_provider_1.CoreClientProvider).toSelf().inSingletonScope();
    // Shared port/board discovery for the server
    bind(board_discovery_1.BoardDiscovery).toSelf().inSingletonScope();
    bind(backend_application_1.BackendApplicationContribution).toService(board_discovery_1.BoardDiscovery);
    // Core service -> `verify` and `upload`. Singleton per BE, each FE connection gets its proxy.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(core_service_impl_1.CoreServiceImpl).toSelf().inSingletonScope();
        bind(core_service_1.CoreService).toService(core_service_impl_1.CoreServiceImpl);
        bindBackendService(core_service_1.CoreServicePath, core_service_1.CoreService);
    }));
    // #region Theia customizations
    bind(default_workspace_server_1.DefaultWorkspaceServer).toSelf().inSingletonScope();
    rebind(common_1.WorkspaceServer).toService(default_workspace_server_1.DefaultWorkspaceServer);
    bind(env_variables_server_1.EnvVariablesServer).toSelf().inSingletonScope();
    rebind(env_variables_1.EnvVariablesServer).toService(env_variables_server_1.EnvVariablesServer);
    // #endregion Theia customizations
    // a single MonitorManager is responsible for handling the actual connections to the pluggable monitors
    bind(monitor_manager_1.MonitorManager).toSelf().inSingletonScope();
    // monitor service & factory bindings
    bind(monitor_settings_provider_impl_1.MonitorSettingsProviderImpl).toSelf().inSingletonScope();
    bind(monitor_settings_provider_1.MonitorSettingsProvider).toService(monitor_settings_provider_impl_1.MonitorSettingsProviderImpl);
    bind(web_socket_provider_impl_1.default).toSelf();
    bind(web_socket_provider_1.WebSocketProvider).toService(web_socket_provider_impl_1.default);
    bind(monitor_service_factory_1.MonitorServiceFactory).toFactory(({ container }) => (options) => {
        const child = container.createChild();
        child
            .bind(monitor_service_factory_1.MonitorServiceFactoryOptions)
            .toConstantValue(Object.assign({}, options));
        child.bind(monitor_service_2.MonitorService).toSelf();
        return child.get(monitor_service_2.MonitorService);
    });
    // Serial client provider per connected frontend.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(monitor_manager_proxy_impl_1.MonitorManagerProxyImpl).toSelf().inSingletonScope();
        bind(monitor_service_1.MonitorManagerProxy).toService(monitor_manager_proxy_impl_1.MonitorManagerProxyImpl);
        bindBackendService(monitor_service_1.MonitorManagerProxyPath, monitor_service_1.MonitorManagerProxy, (monitorMgrProxy, client) => {
            monitorMgrProxy.setClient(client);
            // when the client close the connection, the proxy is disposed.
            // when the MonitorManagerProxy is disposed, it informs the MonitorManager
            // telling him that it does not need an address/board anymore.
            // the MonitorManager will then dispose the actual connection if there are no proxies using it
            client.onDidCloseConnection(() => monitorMgrProxy.dispose());
            return monitorMgrProxy;
        });
    }));
    // File-system extension for mapping paths to URIs
    bind(node_filesystem_ext_1.NodeFileSystemExt).toSelf().inSingletonScope();
    bind(filesystem_ext_1.FileSystemExt).toService(node_filesystem_ext_1.NodeFileSystemExt);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(filesystem_ext_1.FileSystemExtPath, () => context.container.get(filesystem_ext_1.FileSystemExt)))
        .inSingletonScope();
    // Output service per connection.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bindFrontendService }) => {
        bindFrontendService(response_service_1.ResponseServicePath, response_service_1.ResponseService);
    }));
    // Notify all connected frontend instances
    bind(notification_service_server_1.NotificationServiceServerImpl).toSelf().inSingletonScope();
    bind(protocol_1.NotificationServiceServer).toService(notification_service_server_1.NotificationServiceServerImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(protocol_1.NotificationServicePath, (client) => {
        const server = context.container.get(protocol_1.NotificationServiceServer);
        server.setClient(client);
        client.onDidCloseConnection(() => server.disposeClient(client));
        return server;
    }))
        .inSingletonScope();
    // Singleton per BE, each FE connection gets its proxy.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(arduino_firmware_uploader_impl_1.ArduinoFirmwareUploaderImpl).toSelf().inSingletonScope();
        bind(arduino_firmware_uploader_1.ArduinoFirmwareUploader).toService(arduino_firmware_uploader_impl_1.ArduinoFirmwareUploaderImpl);
        bindBackendService(arduino_firmware_uploader_1.ArduinoFirmwareUploaderPath, arduino_firmware_uploader_1.ArduinoFirmwareUploader);
    }));
    // Logger for the Arduino daemon
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child('daemon');
    })
        .inSingletonScope()
        .whenTargetNamed('daemon');
    // Logger for the Arduino daemon
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child('fwuploader');
    })
        .inSingletonScope()
        .whenTargetNamed('fwuploader');
    // Logger for the "serial discovery".
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child('discovery-log'); // TODO: revert
    })
        .inSingletonScope()
        .whenTargetNamed('discovery-log'); // TODO: revert
    // Logger for the CLI config service. From the CLI config (FS path aware), we make a URI-aware app config.
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child('config');
    })
        .inSingletonScope()
        .whenTargetNamed('config');
    // Logger for the monitor manager and its services
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child(monitor_manager_1.MonitorManagerName);
    })
        .inSingletonScope()
        .whenTargetNamed(monitor_manager_1.MonitorManagerName);
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child(monitor_service_2.MonitorServiceName);
    })
        .inSingletonScope()
        .whenTargetNamed(monitor_service_2.MonitorServiceName);
    // Remote sketchbook bindings
    bind(authentication_service_impl_1.AuthenticationServiceImpl).toSelf().inSingletonScope();
    bind(authentication_service_1.AuthenticationService).toService(authentication_service_impl_1.AuthenticationServiceImpl);
    bind(backend_application_1.BackendApplicationContribution).toService(authentication_service_impl_1.AuthenticationServiceImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(authentication_service_1.AuthenticationServicePath, (client) => {
        const server = context.container.get(authentication_service_impl_1.AuthenticationServiceImpl);
        server.setClient(client);
        client.onDidCloseConnection(() => server.disposeClient(client));
        return server;
    }))
        .inSingletonScope();
    bind(plotter_backend_contribution_1.PlotterBackendContribution).toSelf().inSingletonScope();
    bind(backend_application_1.BackendApplicationContribution).toService(plotter_backend_contribution_1.PlotterBackendContribution);
    bind(arduino_localization_contribution_1.ArduinoLocalizationContribution).toSelf().inSingletonScope();
    bind(localization_contribution_1.LocalizationContribution).toService(arduino_localization_contribution_1.ArduinoLocalizationContribution);
    bind(localization_backend_contribution_1.LocalizationBackendContribution).toSelf().inSingletonScope();
    rebind(localization_backend_contribution_2.LocalizationBackendContribution).toService(localization_backend_contribution_1.LocalizationBackendContribution);
    // Survey notification bindings
    // It's currently unused. https://github.com/arduino/arduino-ide/pull/1150
    bind(survey_service_impl_1.SurveyNotificationServiceImpl).toSelf().inSingletonScope();
    bind(survey_service_1.SurveyNotificationService).toService(survey_service_impl_1.SurveyNotificationServiceImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue(({ container }) => new core_1.JsonRpcConnectionHandler(survey_service_1.SurveyNotificationServicePath, () => container.get(survey_service_1.SurveyNotificationService)))
        .inSingletonScope();
    bind(is_temp_sketch_1.IsTempSketch).toSelf().inSingletonScope();
});
//# sourceMappingURL=arduino-ide-backend-module.js.map