"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.style = exports.ClangFormatter = void 0;
const os = require("os");
const env_variables_1 = require("@theia/core/lib/common/env-variables");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const inversify_1 = require("@theia/core/shared/inversify");
const fs_1 = require("fs");
const path_1 = require("path");
const protocol_1 = require("../common/protocol");
const exec_util_1 = require("./exec-util");
let ClangFormatter = class ClangFormatter {
    async format({ content, formatterConfigFolderUris, options, }) {
        const [execPath, style] = await Promise.all([
            this.execPath(),
            this.style(formatterConfigFolderUris, options),
        ]);
        const formatted = await (0, exec_util_1.spawnCommand)(`"${execPath}"`, [style], console.error, content);
        return formatted;
    }
    async execPath() {
        if (this._execPath) {
            return this._execPath;
        }
        this._execPath = await (0, exec_util_1.getExecPath)('clang-format');
        return this._execPath;
    }
    /**
     * Calculates the `-style` flag for the formatter. Uses a `.clang-format` file if exists.
     * Otherwise, falls back to the default config.
     *
     * Style precedence:
     *  1. in the sketch folder,
     *  1. `~/.arduinoIDE/.clang-format`,
     *  1. `directories#data/.clang-format`, and
     *  1. default style flag as a string.
     *
     * See: https://github.com/arduino/arduino-ide/issues/566
     */
    async style(formatterConfigFolderUris, options) {
        const clangFormatPaths = await Promise.all([
            ...formatterConfigFolderUris.map((uri) => this.clangConfigPath(uri)),
            this.clangConfigPath(this.configDirPath()),
            this.clangConfigPath(this.dataDirPath()),
        ]);
        const first = clangFormatPaths.filter(Boolean).shift();
        if (first) {
            console.debug(`Using ${ClangFormatFile} style configuration from '${first}'.`);
            return `-style=file:"${first}"`;
        }
        return `-style="${style(toClangOptions(options))}"`;
    }
    async dataDirPath() {
        const { dataDirUri } = await this.configService.getConfiguration();
        return file_uri_1.FileUri.fsPath(dataDirUri);
    }
    async configDirPath() {
        const configDirUri = await this.envVariableServer.getConfigDirUri();
        return file_uri_1.FileUri.fsPath(configDirUri);
    }
    async clangConfigPath(folderUri) {
        const folderPath = file_uri_1.FileUri.fsPath(await folderUri);
        const clangFormatPath = (0, path_1.join)(folderPath, ClangFormatFile);
        try {
            await fs_1.promises.access(clangFormatPath, fs_1.constants.R_OK);
            return clangFormatPath;
        }
        catch (_a) {
            return undefined;
        }
    }
};
__decorate([
    (0, inversify_1.inject)(protocol_1.ConfigService),
    __metadata("design:type", Object)
], ClangFormatter.prototype, "configService", void 0);
__decorate([
    (0, inversify_1.inject)(env_variables_1.EnvVariablesServer),
    __metadata("design:type", Object)
], ClangFormatter.prototype, "envVariableServer", void 0);
ClangFormatter = __decorate([
    (0, inversify_1.injectable)()
], ClangFormatter);
exports.ClangFormatter = ClangFormatter;
const ClangFormatFile = '.clang-format';
function toClangOptions(options) {
    if (!!options) {
        return {
            UseTab: options.insertSpaces ? 'Never' : 'ForIndentation',
            TabWidth: options.tabSize,
        };
    }
    return { UseTab: 'Never', TabWidth: 2 };
}
function style({ TabWidth, UseTab }) {
    let styleArgument = JSON.stringify(styleJson({ TabWidth, UseTab })).replace(/[\\"]/g, '\\$&');
    if (os.platform() === 'win32') {
        // Windows command interpreter does not use backslash escapes. This causes the argument to have alternate quoted and
        // unquoted sections.
        // Special characters in the unquoted sections must be caret escaped.
        const styleArgumentSplit = styleArgument.split('"');
        for (let i = 1; i < styleArgumentSplit.length; i += 2) {
            styleArgumentSplit[i] = styleArgumentSplit[i].replace(/[<>^|]/g, '^$&');
        }
        styleArgument = styleArgumentSplit.join('"');
    }
    return styleArgument;
}
exports.style = style;
function styleJson({ TabWidth, UseTab, }) {
    // Source: https://github.com/arduino/tooling-project-assets/tree/main/other/clang-format-configuration
    const defaultConfig = require('../../src/node/default-formatter-config.json');
    return Object.assign(Object.assign({}, defaultConfig), { TabWidth,
        UseTab });
}
//# sourceMappingURL=clang-formatter.js.map