"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCliConfig = exports.Logging = exports.Directories = exports.BoardManager = exports.CLI_CONFIG = void 0;
const protocol_1 = require("../common/protocol");
exports.CLI_CONFIG = 'arduino-cli.yaml';
var BoardManager;
(function (BoardManager) {
    function sameAs(left, right) {
        var _a, _b;
        const leftUrls = (_a = left === null || left === void 0 ? void 0 : left.additional_urls) !== null && _a !== void 0 ? _a : [];
        const rightUrls = (_b = right === null || right === void 0 ? void 0 : right.additional_urls) !== null && _b !== void 0 ? _b : [];
        return protocol_1.AdditionalUrls.sameAs(leftUrls, rightUrls);
    }
    BoardManager.sameAs = sameAs;
})(BoardManager = exports.BoardManager || (exports.BoardManager = {}));
var Directories;
(function (Directories) {
    function is(directories) {
        return !!directories && !!directories.data && !!directories.user;
    }
    Directories.is = is;
    function sameAs(left, right) {
        if (left === undefined) {
            return right === undefined;
        }
        if (right === undefined) {
            return left === undefined;
        }
        return left.data === right.data && left.user === right.user;
    }
    Directories.sameAs = sameAs;
})(Directories = exports.Directories || (exports.Directories = {}));
var Logging;
(function (Logging) {
    function sameAs(left, right) {
        if (left === undefined) {
            return right === undefined;
        }
        if (right === undefined) {
            return left === undefined;
        }
        if (left.file !== right.file) {
            return false;
        }
        if (left.format !== right.format) {
            return false;
        }
        if (left.level !== right.level) {
            return false;
        }
        return true;
    }
    Logging.sameAs = sameAs;
})(Logging = exports.Logging || (exports.Logging = {}));
var DefaultCliConfig;
(function (DefaultCliConfig) {
    function is(config) {
        return !!config && Directories.is(config.directories);
    }
    DefaultCliConfig.is = is;
    function sameAs(left, right) {
        return (Directories.sameAs(left.directories, right.directories) &&
            BoardManager.sameAs(left.board_manager, right.board_manager) &&
            Logging.sameAs(left.logging, right.logging));
    }
    DefaultCliConfig.sameAs = sameAs;
})(DefaultCliConfig = exports.DefaultCliConfig || (exports.DefaultCliConfig = {}));
//# sourceMappingURL=cli-config.js.map