"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigServiceImpl = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
const yaml = require("js-yaml");
const grpc = require("@grpc/grpc-js");
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const logger_1 = require("@theia/core/lib/common/logger");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const event_1 = require("@theia/core/lib/common/event");
const protocol_1 = require("../common/protocol");
const exec_util_1 = require("./exec-util");
const settings_pb_1 = require("./cli-protocol/cc/arduino/cli/settings/v1/settings_pb");
const serviceGrpcPb = require("./cli-protocol/cc/arduino/cli/settings/v1/settings_grpc_pb");
const arduino_daemon_impl_1 = require("./arduino-daemon-impl");
const cli_config_1 = require("./cli-config");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
const env_variables_1 = require("@theia/core/lib/common/env-variables");
const core_1 = require("@theia/core");
const decorators_1 = require("../common/decorators");
const deepmerge = require('deepmerge');
let ConfigServiceImpl = class ConfigServiceImpl {
    constructor() {
        this.ready = new promise_util_1.Deferred();
        this.configChangeEmitter = new event_1.Emitter();
    }
    onStart() {
        this.loadCliConfig().then(async (cliConfig) => {
            this.cliConfig = cliConfig;
            if (this.cliConfig) {
                const config = await this.mapCliConfigToAppConfig(this.cliConfig);
                if (config) {
                    this.config = config;
                    this.ready.resolve();
                    return;
                }
            }
            this.fireInvalidConfig();
        });
    }
    async getCliConfigFileUri() {
        const configDirUri = await this.envVariablesServer.getConfigDirUri();
        return new uri_1.default(configDirUri).resolve(cli_config_1.CLI_CONFIG).toString();
    }
    async getConfiguration() {
        await this.ready.promise;
        return Object.assign({}, this.config);
    }
    // Used by frontend to update the config.
    async setConfiguration(config) {
        await this.ready.promise;
        if (protocol_1.Config.sameAs(this.config, config)) {
            return;
        }
        let copyDefaultCliConfig = (0, core_1.deepClone)(this.cliConfig);
        if (!copyDefaultCliConfig) {
            copyDefaultCliConfig = await this.getFallbackCliConfig();
        }
        const { additionalUrls, dataDirUri, sketchDirUri, network, locale } = config;
        copyDefaultCliConfig.directories = {
            data: file_uri_1.FileUri.fsPath(dataDirUri),
            user: file_uri_1.FileUri.fsPath(sketchDirUri),
        };
        copyDefaultCliConfig.board_manager = {
            additional_urls: [...additionalUrls],
        };
        copyDefaultCliConfig.locale = locale || 'en';
        const proxy = protocol_1.Network.stringify(network);
        copyDefaultCliConfig.network = { proxy };
        // always use the port of the daemon
        const port = await this.daemon.getPort();
        await this.updateDaemon(port, copyDefaultCliConfig);
        await this.writeDaemonState(port);
        this.config = (0, core_1.deepClone)(config);
        this.cliConfig = copyDefaultCliConfig;
        this.fireConfigChanged(this.config);
    }
    get cliConfiguration() {
        return this.cliConfig;
    }
    get onConfigChange() {
        return this.configChangeEmitter.event;
    }
    async getVersion() {
        return this.daemon.getVersion();
    }
    async loadCliConfig(initializeIfAbsent = true) {
        const cliConfigFileUri = await this.getCliConfigFileUri();
        const cliConfigPath = file_uri_1.FileUri.fsPath(cliConfigFileUri);
        try {
            const content = await fs_1.promises.readFile(cliConfigPath, {
                encoding: 'utf8',
            });
            const model = (yaml.safeLoad(content) || {});
            if (model.directories.data && model.directories.user) {
                return model;
            }
            // The CLI can run with partial (missing `port`, `directories`), the IDE2 cannot.
            // We merge the default CLI config with the partial user's config.
            const fallbackModel = await this.getFallbackCliConfig();
            return deepmerge(fallbackModel, model);
        }
        catch (error) {
            if ('code' in error && error.code === 'ENOENT') {
                if (initializeIfAbsent) {
                    await this.initCliConfigTo((0, path_1.dirname)(cliConfigPath));
                    return this.loadCliConfig(false);
                }
            }
            throw error;
        }
    }
    async getFallbackCliConfig() {
        const cliPath = await this.daemon.getExecPath();
        const rawJson = await (0, exec_util_1.spawnCommand)(`"${cliPath}"`, [
            'config',
            'dump',
            'format',
            '--json',
        ]);
        return JSON.parse(rawJson);
    }
    async initCliConfigTo(fsPathToDir) {
        const cliPath = await this.daemon.getExecPath();
        await (0, exec_util_1.spawnCommand)(`"${cliPath}"`, [
            'config',
            'init',
            '--dest-dir',
            `"${fsPathToDir}"`,
        ]);
    }
    async mapCliConfigToAppConfig(cliConfig) {
        var _a;
        const { directories, locale = 'en' } = cliConfig;
        const { user, data } = directories;
        const additionalUrls = [];
        if (cliConfig.board_manager && cliConfig.board_manager.additional_urls) {
            additionalUrls.push(...Array.from(new Set(cliConfig.board_manager.additional_urls)));
        }
        const network = protocol_1.Network.parse((_a = cliConfig.network) === null || _a === void 0 ? void 0 : _a.proxy);
        return {
            dataDirUri: file_uri_1.FileUri.create(data).toString(),
            sketchDirUri: file_uri_1.FileUri.create(user).toString(),
            additionalUrls,
            network,
            locale,
        };
    }
    fireConfigChanged(config) {
        this.configChangeEmitter.fire(config);
        this.notificationService.notifyConfigDidChange({ config });
    }
    fireInvalidConfig() {
        this.notificationService.notifyConfigDidChange({ config: undefined });
    }
    async updateDaemon(port, config) {
        const client = this.createClient(port);
        const req = new settings_pb_1.MergeRequest();
        const json = JSON.stringify(config, null, 2);
        req.setJsonData(json);
        console.log(`Updating daemon with 'data': ${json}`);
        return new Promise((resolve, reject) => {
            client.merge(req, (error) => {
                try {
                    if (error) {
                        reject(error);
                        return;
                    }
                    resolve();
                }
                finally {
                    client.close();
                }
            });
        });
    }
    async writeDaemonState(port) {
        const client = this.createClient(port);
        const req = new settings_pb_1.WriteRequest();
        const cliConfigUri = await this.getCliConfigFileUri();
        const cliConfigPath = file_uri_1.FileUri.fsPath(cliConfigUri);
        req.setFilePath(cliConfigPath);
        return new Promise((resolve, reject) => {
            client.write(req, (error) => {
                try {
                    if (error) {
                        reject(error);
                        return;
                    }
                    resolve();
                }
                finally {
                    client.close();
                }
            });
        });
    }
    createClient(port) {
        // https://github.com/agreatfool/grpc_tools_node_protoc_ts/blob/master/doc/grpcjs_support.md#usage
        const SettingsServiceClient = grpc.makeClientConstructor(
        // @ts-expect-error: ignore
        serviceGrpcPb['cc.arduino.cli.settings.v1.SettingsService'], 'SettingsServiceService');
        return new SettingsServiceClient(`localhost:${port}`, grpc.credentials.createInsecure());
    }
};
__decorate([
    (0, inversify_1.inject)(logger_1.ILogger),
    (0, inversify_1.named)('config'),
    __metadata("design:type", Object)
], ConfigServiceImpl.prototype, "logger", void 0);
__decorate([
    (0, inversify_1.inject)(env_variables_1.EnvVariablesServer),
    __metadata("design:type", Object)
], ConfigServiceImpl.prototype, "envVariablesServer", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_daemon_impl_1.ArduinoDaemonImpl),
    __metadata("design:type", arduino_daemon_impl_1.ArduinoDaemonImpl)
], ConfigServiceImpl.prototype, "daemon", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.NotificationServiceServer),
    __metadata("design:type", Object)
], ConfigServiceImpl.prototype, "notificationService", void 0);
__decorate([
    (0, decorators_1.duration)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ConfigServiceImpl.prototype, "loadCliConfig", null);
ConfigServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], ConfigServiceImpl);
exports.ConfigServiceImpl = ConfigServiceImpl;
//# sourceMappingURL=config-service-impl.js.map