"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CoreServiceImpl = void 0;
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const inversify_1 = require("@theia/core/shared/inversify");
const path_1 = require("path");
const wrappers_pb_1 = require("google-protobuf/google/protobuf/wrappers_pb");
const core_service_1 = require("../common/protocol/core-service");
const compile_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/compile_pb");
const core_client_provider_1 = require("./core-client-provider");
const upload_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/upload_pb");
const response_service_1 = require("../common/protocol/response-service");
const protocol_1 = require("../common/protocol");
const port_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/port_pb");
const core_1 = require("@theia/core");
const monitor_manager_1 = require("./monitor-manager");
const buffers_1 = require("./utils/buffers");
const cli_error_parser_1 = require("./cli-error-parser");
const utils_1 = require("../common/utils");
const service_error_1 = require("./service-error");
const grpc_progressible_1 = require("./grpc-progressible");
const board_discovery_1 = require("./board-discovery");
let CoreServiceImpl = class CoreServiceImpl extends core_client_provider_1.CoreClientAware {
    async compile(options) {
        const coreClient = await this.coreClient;
        const { client, instance } = coreClient;
        let buildPath = undefined;
        const progressHandler = this.createProgressHandler(options);
        const buildPathHandler = (response) => {
            const currentBuildPath = response.getBuildPath();
            if (currentBuildPath) {
                buildPath = currentBuildPath;
            }
            else {
                if (!!buildPath && currentBuildPath !== buildPath) {
                    throw new Error(`The CLI has already provided a build path: <${buildPath}>, and IDE received a new build path value: <${currentBuildPath}>.`);
                }
            }
        };
        const handler = this.createOnDataHandler(progressHandler, buildPathHandler);
        const request = this.compileRequest(options, instance);
        return new Promise((resolve, reject) => {
            client
                .compile(request)
                .on('data', handler.onData)
                .on('error', (error) => {
                var _a;
                if (!service_error_1.ServiceError.is(error)) {
                    console.error('Unexpected error occurred while compiling the sketch.', error);
                    reject(error);
                }
                else {
                    const compilerErrors = (0, cli_error_parser_1.tryParseError)({
                        content: handler.content,
                        sketch: options.sketch,
                    });
                    const message = core_1.nls.localize('arduino/compile/error', 'Compilation error: {0}', (_a = compilerErrors
                        .map(({ message }) => message)
                        .filter(utils_1.notEmpty)
                        .shift()) !== null && _a !== void 0 ? _a : error.details);
                    this.sendResponse(error.details + '\n\n' + message, protocol_1.OutputMessage.Severity.Error);
                    reject(core_service_1.CoreError.VerifyFailed(message, compilerErrors));
                }
            })
                .on('end', resolve);
        }).finally(() => {
            handler.dispose();
            if (!buildPath) {
                console.error(`Have not received the build path from the CLI while running the compilation.`);
            }
            else {
                this.fireBuildDidComplete(file_uri_1.FileUri.create(buildPath).toString());
            }
        });
    }
    // This executes on the frontend, the VS Code extension receives it, and sends an `ino/buildDidComplete` notification to the language server.
    fireBuildDidComplete(buildOutputUri) {
        const params = {
            buildOutputUri,
        };
        console.info(`Executing 'arduino.languageserver.notifyBuildDidComplete' with ${JSON.stringify(params)}`);
        this.commandService
            .executeCommand('arduino.languageserver.notifyBuildDidComplete', params)
            .catch((err) => console.error(`Unexpected error when firing event on build did complete. ${buildOutputUri}`, err));
    }
    compileRequest(options, instance) {
        const { sketch, fqbn, compilerWarnings } = options;
        const sketchUri = sketch.uri;
        const sketchPath = file_uri_1.FileUri.fsPath(sketchUri);
        const request = new compile_pb_1.CompileRequest();
        request.setInstance(instance);
        request.setSketchPath(sketchPath);
        if (fqbn) {
            request.setFqbn(fqbn);
        }
        if (compilerWarnings) {
            request.setWarnings(compilerWarnings.toLowerCase());
        }
        request.setOptimizeForDebug(options.optimizeForDebug);
        request.setPreprocess(false);
        request.setVerbose(options.verbose);
        request.setQuiet(false);
        if (typeof options.exportBinaries === 'boolean') {
            const exportBinaries = new wrappers_pb_1.BoolValue();
            exportBinaries.setValue(options.exportBinaries);
            request.setExportBinaries(exportBinaries);
        }
        this.mergeSourceOverrides(request, options);
        return request;
    }
    upload(options) {
        const { usingProgrammer } = options;
        return this.doUpload(options, usingProgrammer
            ? new upload_pb_1.UploadUsingProgrammerRequest()
            : new upload_pb_1.UploadRequest(), (client) => (usingProgrammer ? client.uploadUsingProgrammer : client.upload).bind(client), usingProgrammer
            ? core_service_1.CoreError.UploadUsingProgrammerFailed
            : core_service_1.CoreError.UploadFailed, `upload${usingProgrammer ? ' using programmer' : ''}`);
    }
    async doUpload(options, request, responseFactory, errorCtor, task) {
        const coreClient = await this.coreClient;
        const { client, instance } = coreClient;
        const progressHandler = this.createProgressHandler(options);
        const handler = this.createOnDataHandler(progressHandler);
        const grpcCall = responseFactory(client);
        return this.notifyUploadWillStart(options).then(() => new Promise((resolve, reject) => {
            grpcCall(this.initUploadRequest(request, options, instance))
                .on('data', handler.onData)
                .on('error', (error) => {
                if (!service_error_1.ServiceError.is(error)) {
                    console.error(`Unexpected error occurred while ${task}.`, error);
                    reject(error);
                }
                else {
                    const message = core_1.nls.localize('arduino/upload/error', '{0} error: {1}', (0, utils_1.firstToUpperCase)(task), error.details);
                    this.sendResponse(error.details, protocol_1.OutputMessage.Severity.Error);
                    reject(errorCtor(message, (0, cli_error_parser_1.tryParseError)({
                        content: handler.content,
                        sketch: options.sketch,
                    })));
                }
            })
                .on('end', resolve);
        }).finally(async () => {
            handler.dispose();
            await this.notifyUploadDidFinish(options);
        }));
    }
    initUploadRequest(request, options, instance) {
        const { sketch, fqbn, port, programmer } = options;
        const sketchPath = file_uri_1.FileUri.fsPath(sketch.uri);
        request.setInstance(instance);
        request.setSketchPath(sketchPath);
        if (fqbn) {
            request.setFqbn(fqbn);
        }
        request.setPort(this.createPort(port));
        if (programmer) {
            request.setProgrammer(programmer.id);
        }
        request.setVerbose(options.verbose);
        request.setVerify(options.verify);
        options.userFields.forEach((e) => {
            request.getUserFieldsMap().set(e.name, e.value);
        });
        return request;
    }
    async burnBootloader(options) {
        const coreClient = await this.coreClient;
        const { client, instance } = coreClient;
        const progressHandler = this.createProgressHandler(options);
        const handler = this.createOnDataHandler(progressHandler);
        const request = this.burnBootloaderRequest(options, instance);
        return this.notifyUploadWillStart(options).then(() => new Promise((resolve, reject) => {
            client
                .burnBootloader(request)
                .on('data', handler.onData)
                .on('error', (error) => {
                if (!service_error_1.ServiceError.is(error)) {
                    console.error('Unexpected error occurred while burning the bootloader.', error);
                    reject(error);
                }
                else {
                    this.sendResponse(error.details, protocol_1.OutputMessage.Severity.Error);
                    reject(core_service_1.CoreError.BurnBootloaderFailed(core_1.nls.localize('arduino/burnBootloader/error', 'Error while burning the bootloader: {0}', error.details), (0, cli_error_parser_1.tryParseError)({ content: handler.content })));
                }
            })
                .on('end', resolve);
        }).finally(async () => {
            handler.dispose();
            await this.notifyUploadDidFinish(options);
        }));
    }
    burnBootloaderRequest(options, instance) {
        const { fqbn, port, programmer } = options;
        const request = new upload_pb_1.BurnBootloaderRequest();
        request.setInstance(instance);
        if (fqbn) {
            request.setFqbn(fqbn);
        }
        request.setPort(this.createPort(port));
        if (programmer) {
            request.setProgrammer(programmer.id);
        }
        request.setVerify(options.verify);
        request.setVerbose(options.verbose);
        return request;
    }
    createProgressHandler(options) {
        // If client did not provide the progress ID, do nothing.
        if (!options.progressId) {
            return () => {
                /* NOOP */
            };
        }
        return grpc_progressible_1.ExecuteWithProgress.createDataCallback({
            progressId: options.progressId,
            responseService: this.responseService,
        });
    }
    createOnDataHandler(
    // TODO: why not creating a composite handler with progress, `build_path`, and out/err stream handlers?
    ...handlers) {
        const content = [];
        const buffer = new buffers_1.AutoFlushingBuffer((chunks) => {
            chunks.forEach(([severity, chunk]) => this.sendResponse(chunk, severity));
        });
        const onData = StreamingResponse.createOnDataHandler({
            content,
            onData: (out, err) => {
                buffer.addChunk(out);
                buffer.addChunk(err, protocol_1.OutputMessage.Severity.Error);
            },
            handlers,
        });
        return {
            dispose: () => buffer.dispose(),
            content,
            onData,
        };
    }
    sendResponse(chunk, severity = protocol_1.OutputMessage.Severity.Info) {
        this.responseService.appendToOutput({ chunk, severity });
    }
    async notifyUploadWillStart({ fqbn, port, }) {
        this.boardDiscovery.setUploadInProgress(true);
        return this.monitorManager.notifyUploadStarted(fqbn, port);
    }
    async notifyUploadDidFinish({ fqbn, port, }) {
        this.boardDiscovery.setUploadInProgress(false);
        return this.monitorManager.notifyUploadFinished(fqbn, port);
    }
    mergeSourceOverrides(req, options) {
        const sketchPath = file_uri_1.FileUri.fsPath(options.sketch.uri);
        for (const uri of Object.keys(options.sourceOverride)) {
            const content = options.sourceOverride[uri];
            if (content) {
                const relativePath = (0, path_1.relative)(sketchPath, file_uri_1.FileUri.fsPath(uri));
                req.getSourceOverrideMap().set(relativePath, content);
            }
        }
    }
    createPort(port) {
        const rpcPort = new port_pb_1.Port();
        if (port) {
            rpcPort.setAddress(port.address);
            rpcPort.setLabel(port.addressLabel);
            rpcPort.setProtocol(port.protocol);
            rpcPort.setProtocolLabel(port.protocolLabel);
            if (port.properties) {
                for (const [key, value] of Object.entries(port.properties)) {
                    rpcPort.getPropertiesMap().set(key, value);
                }
            }
        }
        return rpcPort;
    }
};
__decorate([
    (0, inversify_1.inject)(response_service_1.ResponseService),
    __metadata("design:type", Object)
], CoreServiceImpl.prototype, "responseService", void 0);
__decorate([
    (0, inversify_1.inject)(monitor_manager_1.MonitorManager),
    __metadata("design:type", monitor_manager_1.MonitorManager)
], CoreServiceImpl.prototype, "monitorManager", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.CommandService),
    __metadata("design:type", Object)
], CoreServiceImpl.prototype, "commandService", void 0);
__decorate([
    (0, inversify_1.inject)(board_discovery_1.BoardDiscovery),
    __metadata("design:type", board_discovery_1.BoardDiscovery)
], CoreServiceImpl.prototype, "boardDiscovery", void 0);
CoreServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], CoreServiceImpl);
exports.CoreServiceImpl = CoreServiceImpl;
var StreamingResponse;
(function (StreamingResponse) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    function createOnDataHandler(options) {
        return (response) => {
            var _a;
            const out = response.getOutStream_asU8();
            if (out.length) {
                options.content.push(out);
            }
            const err = response.getErrStream_asU8();
            if (err.length) {
                options.content.push(err);
            }
            options.onData(out, err);
            (_a = options.handlers) === null || _a === void 0 ? void 0 : _a.forEach((handler) => handler(response));
        };
    }
    StreamingResponse.createOnDataHandler = createOnDataHandler;
})(StreamingResponse || (StreamingResponse = {}));
//# sourceMappingURL=core-service-impl.js.map