"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExamplesServiceImpl = exports.BuiltInExamplesServiceImpl = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const path_1 = require("path");
const fs = require("fs");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const sketches_service_1 = require("../common/protocol/sketches-service");
const protocol_1 = require("../common/protocol");
const decorators_1 = require("../common/decorators");
const uri_1 = require("@theia/core/lib/common/uri");
const path_2 = require("@theia/core/lib/common/path");
var BuiltInSketchRef;
(function (BuiltInSketchRef) {
    function toSketchRef({ name, relativePath }, root) {
        return {
            name,
            uri: root.resolve(relativePath).toString(),
        };
    }
    BuiltInSketchRef.toSketchRef = toSketchRef;
})(BuiltInSketchRef || (BuiltInSketchRef = {}));
var BuiltInSketchContainer;
(function (BuiltInSketchContainer) {
    function toSketchContainer(source, root) {
        return {
            label: source.label,
            children: source.children.map((child) => toSketchContainer(child, root)),
            sketches: source.sketches.map((child) => BuiltInSketchRef.toSketchRef(child, root)),
        };
    }
    BuiltInSketchContainer.toSketchContainer = toSketchContainer;
})(BuiltInSketchContainer || (BuiltInSketchContainer = {}));
let BuiltInExamplesServiceImpl = class BuiltInExamplesServiceImpl {
    init() {
        this.builtIns();
    }
    async builtIns() {
        if (this._builtIns) {
            return this._builtIns;
        }
        const examplesRootPath = (0, path_1.join)(__dirname, '..', '..', 'Examples');
        const examplesRootUri = file_uri_1.FileUri.create(examplesRootPath);
        const rawJson = await fs.promises.readFile((0, path_1.join)(examplesRootPath, 'examples.json'), { encoding: 'utf8' });
        const examples = JSON.parse(rawJson);
        this._builtIns = examples.map((container) => BuiltInSketchContainer.toSketchContainer(container, examplesRootUri));
        return this._builtIns;
    }
};
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], BuiltInExamplesServiceImpl.prototype, "init", null);
BuiltInExamplesServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], BuiltInExamplesServiceImpl);
exports.BuiltInExamplesServiceImpl = BuiltInExamplesServiceImpl;
let ExamplesServiceImpl = class ExamplesServiceImpl {
    builtIns() {
        return this.builtInExamplesService.builtIns();
    }
    async installed({ fqbn }) {
        const user = [];
        const current = [];
        const any = [];
        const packages = await this.libraryService.list({
            fqbn,
        });
        for (const pkg of packages) {
            const container = await this.tryGroupExamples(pkg);
            const { location } = pkg;
            if (location === protocol_1.LibraryLocation.USER) {
                user.push(container);
            }
            else if (location === protocol_1.LibraryLocation.PLATFORM_BUILTIN ||
                protocol_1.LibraryLocation.REFERENCED_PLATFORM_BUILTIN) {
                current.push(container);
            }
            else {
                any.push(container);
            }
        }
        return { user, current, any };
    }
    /**
     * The CLI provides direct FS paths to the examples so that menus and menu groups cannot be built for the UI by traversing the
     * folder hierarchy. This method tries to workaround it by falling back to the `installDirUri` and manually creating the
     * location of the examples. Otherwise it creates the example container from the direct examples FS paths.
     */
    async tryGroupExamples({ label, exampleUris, installDirUri, }) {
        const container = sketches_service_1.SketchContainer.create(label);
        if (!installDirUri || !exampleUris.length) {
            return container;
        }
        // Args example:
        // exampleUris
        // 0:'file:///Users/a.kitta/Documents/Arduino/libraries/ATOM_DTU_CAT1/examples/MQTT'
        // 1:'file:///Users/a.kitta/Documents/Arduino/libraries/ATOM_DTU_CAT1/examples/Modbus/ModBus-RTU/Master'
        // 2:'file:///Users/a.kitta/Documents/Arduino/libraries/ATOM_DTU_CAT1/examples/Modbus/ModBus-RTU/Slave'
        // installDirUri
        // 'file:///Users/a.kitta/Documents/Arduino/libraries/ATOM_DTU_CAT1'
        // Expected menu structure:
        // ATOM_DTU_CAT1 > Modbus > ModBus-RTU > Master
        //               |                     > Slave
        //               > MQTT
        const logInfo = (ref) => `Example URI: ${ref.uri}, install location URI: ${installDirUri}.`;
        for (const ref of exampleUris.map(sketches_service_1.SketchRef.fromUri)) {
            const path = new uri_1.URI(installDirUri).relative(new uri_1.URI(ref.uri));
            if (!path) {
                console.warn(`Could not resolve the sketch location from its install location. Skipping. ${logInfo(ref)}`);
                continue;
            }
            if (path.isAbsolute) {
                console.warn(`Expected a relative path between the sketch and the install locations. Skipping. Path was: ${path}. ${logInfo(ref)}`);
                continue;
            }
            const pathSegments = path.toString().split(path_2.Path.separator);
            if (pathSegments.length < 2) {
                console.warn(`Expected at least two segments long relative path. Skipping. Path segments were: ${pathSegments}. ${logInfo(ref)}`);
                continue;
            }
            // the relative must start start with `example` or `Examples` or `EXAMPLE`, .etc. It's open source.
            if (!/^examples?$/gi.test(pathSegments[0])) {
                console.warn(`First segment must start with "examples-like". More formally: \`/^examples?$/gi\`. Path segments were: ${pathSegments}. ${logInfo(ref)}`);
            }
            const getOrCreateChildContainer = (label, parent) => {
                let child = parent.children.find(({ label: childLabel }) => childLabel === label);
                if (!child) {
                    child = sketches_service_1.SketchContainer.create(label);
                    parent.children.push(child);
                }
                return child;
            };
            const refContainer = pathSegments.reduce((container, segment, index, segments) => {
                if (index === 0) {
                    // skip the first "example-like" segment
                    return container;
                }
                if (index === segments.length - 1) {
                    // if last segment, it's the example sketch itself, do not create container for it.
                    return container;
                }
                return getOrCreateChildContainer(segment, container);
            }, container);
            refContainer.sketches.push(ref);
        }
        return container;
    }
};
__decorate([
    (0, inversify_1.inject)(protocol_1.LibraryService),
    __metadata("design:type", Object)
], ExamplesServiceImpl.prototype, "libraryService", void 0);
__decorate([
    (0, inversify_1.inject)(BuiltInExamplesServiceImpl),
    __metadata("design:type", BuiltInExamplesServiceImpl)
], ExamplesServiceImpl.prototype, "builtInExamplesService", void 0);
__decorate([
    (0, decorators_1.duration)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ExamplesServiceImpl.prototype, "installed", null);
ExamplesServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], ExamplesServiceImpl);
exports.ExamplesServiceImpl = ExamplesServiceImpl;
//# sourceMappingURL=examples-service-impl.js.map