"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalizationBackendContribution = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const localization_backend_contribution_1 = require("@theia/core/lib/node/i18n/localization-backend-contribution");
const plugin_protocol_1 = require("@theia/plugin-ext/lib/common/plugin-protocol");
const plugin_deployer_impl_1 = require("@theia/plugin-ext/lib/main/node/plugin-deployer-impl");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
let LocalizationBackendContribution = class LocalizationBackendContribution extends localization_backend_contribution_1.LocalizationBackendContribution {
    constructor() {
        super(...arguments);
        this.initialized = new promise_util_1.Deferred();
    }
    async initialize() {
        this.pluginDeployer.onDidDeploy(() => {
            this.initialized.resolve();
        });
        return super.initialize();
    }
    configure(app) {
        app.get('/i18n/:locale', async (req, res) => {
            let locale = req.params.locale;
            /*
              Waiting for the deploy of the language plugins is neecessary to avoid checking the available
              languages before they're finished to be loaded: https://github.com/eclipse-theia/theia/issues/11471
            */
            const start = performance.now();
            await this.initialized.promise;
            console.info('Waiting for the deploy of the language plugins took: ' +
                (performance.now() - start) +
                ' ms.');
            locale = this.localizationProvider
                .getAvailableLanguages()
                .some((e) => e.languageId === locale)
                ? locale
                : 'en';
            this.localizationProvider.setCurrentLanguage(locale);
            res.send(this.localizationProvider.loadLocalization(locale));
        });
    }
};
__decorate([
    (0, inversify_1.inject)(plugin_protocol_1.PluginDeployer),
    __metadata("design:type", plugin_deployer_impl_1.PluginDeployerImpl)
], LocalizationBackendContribution.prototype, "pluginDeployer", void 0);
LocalizationBackendContribution = __decorate([
    (0, inversify_1.injectable)()
], LocalizationBackendContribution);
exports.LocalizationBackendContribution = LocalizationBackendContribution;
//# sourceMappingURL=localization-backend-contribution.js.map