"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.maybeNormalizeDrive = exports.IsTempSketch = exports.TempSketchPrefix = void 0;
const fs = require("fs");
const tempDir = require("temp-dir");
const os_1 = require("@theia/core/lib/common/os");
const inversify_1 = require("@theia/core/shared/inversify");
const utils_1 = require("../common/utils");
const Win32DriveRegex = /^[a-zA-Z]:\\/;
exports.TempSketchPrefix = '.arduinoIDE-unsaved';
let IsTempSketch = class IsTempSketch {
    constructor() {
        // If on macOS, the `temp-dir` lib will make sure there is resolved realpath.
        // If on Windows, the `C:\Users\KITTAA~1\AppData\Local\Temp` path will be resolved and normalized to `C:\Users\kittaakos\AppData\Local\Temp`.
        // Note: VS Code URI normalizes the drive letter. `C:` will be converted into `c:`.
        // https://github.com/Microsoft/vscode/issues/68325#issuecomment-462239992
        this.tempDirRealpath = os_1.isOSX
            ? tempDir
            : maybeNormalizeDrive(fs.realpathSync.native(tempDir));
    }
    is(sketchPath) {
        // Consider the following paths:
        // macOS:
        // - Temp folder: /var/folders/k3/d2fkvv1j16v3_rz93k7f74180000gn/T
        // - Sketch folder: /private/var/folders/k3/d2fkvv1j16v3_rz93k7f74180000gn/T/arduino-ide2-A0337D47F86B24A51DF3DBCF2CC17925
        // Windows:
        // - Temp folder: C:\Users\KITTAA~1\AppData\Local\Temp
        // - Sketch folder: c:\Users\kittaakos\AppData\Local\Temp\.arduinoIDE-unsaved2022431-21824-116kfaz.9ljl\sketch_may31a
        // Both sketches are valid and temp, but this function will give a false-negative result if we use the default `os.tmpdir()` logic.
        const normalizedSketchPath = maybeNormalizeDrive(sketchPath);
        const result = normalizedSketchPath.startsWith(this.tempDirRealpath) &&
            normalizedSketchPath.includes(exports.TempSketchPrefix);
        console.debug(`isTempSketch: ${result}. Input was ${normalizedSketchPath}`);
        return result;
    }
};
IsTempSketch = __decorate([
    (0, inversify_1.injectable)()
], IsTempSketch);
exports.IsTempSketch = IsTempSketch;
/**
 * If on Windows, will change the input `C:\\path\\to\\somewhere` to `c:\\path\\to\\somewhere`.
 * Otherwise, returns with the argument.
 */
function maybeNormalizeDrive(fsPath) {
    if (os_1.isWindows && Win32DriveRegex.test(fsPath)) {
        return (0, utils_1.firstToLowerCase)(fsPath);
    }
    return fsPath;
}
exports.maybeNormalizeDrive = maybeNormalizeDrive;
//# sourceMappingURL=is-temp-sketch.js.map