"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryServiceImpl = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const library_service_1 = require("../common/protocol/library-service");
const core_client_provider_1 = require("./core-client-provider");
const board_discovery_1 = require("./board-discovery");
const lib_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/lib_pb");
const installable_1 = require("../common/protocol/installable");
const core_1 = require("@theia/core");
const node_1 = require("@theia/core/lib/node");
const protocol_1 = require("../common/protocol");
const grpc_progressible_1 = require("./grpc-progressible");
const decorators_1 = require("../common/decorators");
let LibraryServiceImpl = class LibraryServiceImpl extends core_client_provider_1.CoreClientAware {
    async search(options) {
        const coreClient = await this.coreClient;
        const { client, instance } = coreClient;
        const listReq = new lib_pb_1.LibraryListRequest();
        listReq.setInstance(instance);
        const installedLibsResp = await new Promise((resolve, reject) => client.libraryList(listReq, (err, resp) => !!err ? reject(err) : resolve(resp)));
        const installedLibs = installedLibsResp.getInstalledLibrariesList();
        const installedLibsIdx = new Map();
        for (const installedLib of installedLibs) {
            if (installedLib.hasLibrary()) {
                const lib = installedLib.getLibrary();
                if (lib) {
                    installedLibsIdx.set(lib.getRealName(), installedLib);
                }
            }
        }
        const req = new lib_pb_1.LibrarySearchRequest();
        req.setQuery(options.query || '');
        req.setInstance(instance);
        const resp = await new Promise((resolve, reject) => client.librarySearch(req, (err, resp) => !!err ? reject(err) : resolve(resp)));
        const items = resp
            .getLibrariesList()
            .filter((item) => !!item.getLatest())
            .map((item) => {
            // TODO: This seems to contain only the latest item instead of all of the items.
            const availableVersions = item
                .getReleasesMap()
                .getEntryList()
                .map(([key, _]) => key)
                .sort(installable_1.Installable.Version.COMPARATOR)
                .reverse();
            let installedVersion;
            const installed = installedLibsIdx.get(item.getName());
            if (installed) {
                installedVersion = installed.getLibrary().getVersion();
            }
            return toLibrary({
                name: item.getName(),
                installable: true,
                installedVersion,
            }, item.getLatest(), availableVersions);
        });
        const typePredicate = this.typePredicate(options);
        const topicPredicate = this.topicPredicate(options);
        return items.filter((item) => typePredicate(item) && topicPredicate(item));
    }
    typePredicate(options) {
        const { type } = options;
        if (!type || type === 'All') {
            return () => true;
        }
        switch (options.type) {
            case 'Installed':
                return installable_1.Installable.Installed;
            case 'Updatable':
                return installable_1.Installable.Updateable;
            case 'Arduino':
            case 'Partner':
            case 'Recommended':
            case 'Contributed':
            case 'Retired':
                return ({ types }) => !!types && types.includes(type);
            default:
                throw new Error(`Unhandled type: ${options.type}`);
        }
    }
    topicPredicate(options) {
        const { topic } = options;
        if (!topic || topic === 'All') {
            return () => true;
        }
        return (item) => item.category === topic;
    }
    async list({ fqbn, }) {
        const coreClient = await this.coreClient;
        const { client, instance } = coreClient;
        const req = new lib_pb_1.LibraryListRequest();
        req.setInstance(instance);
        if (fqbn) {
            // Only get libraries from the cores when the FQBN is defined. Otherwise, we retrieve user installed libraries only.
            req.setAll(true); // https://github.com/arduino/arduino-ide/pull/303#issuecomment-815556447
            req.setFqbn(fqbn);
        }
        const resp = await new Promise((resolve, reject) => {
            client.libraryList(req, (error, r) => {
                if (error) {
                    const { message } = error;
                    // Required core dependency is missing.
                    // https://github.com/arduino/arduino-cli/issues/954
                    if (message.indexOf('missing platform release') !== -1 &&
                        message.indexOf('referenced by board') !== -1) {
                        resolve(undefined);
                        return;
                    }
                    // The core for the board is not installed, `lib list` cannot be filtered based on FQBN.
                    // https://github.com/arduino/arduino-cli/issues/955
                    if (message.indexOf('platform') !== -1 &&
                        message.indexOf('is not installed') !== -1) {
                        resolve(undefined);
                        return;
                    }
                    // It's a hack to handle https://github.com/arduino/arduino-cli/issues/1262 gracefully.
                    if (message.indexOf('unknown package') !== -1) {
                        resolve(undefined);
                        return;
                    }
                    reject(error);
                    return;
                }
                resolve(r);
            });
        });
        if (!resp) {
            return [];
        }
        return resp
            .getInstalledLibrariesList()
            .map((item) => {
            const library = item.getLibrary();
            if (!library) {
                return undefined;
            }
            const installedVersion = library.getVersion();
            return toLibrary({
                name: library.getName(),
                label: library.getRealName(),
                installedVersion,
                installable: true,
                description: library.getSentence(),
                summary: library.getParagraph(),
                moreInfoLink: library.getWebsite(),
                includes: library.getProvidesIncludesList(),
                location: this.mapLocation(library.getLocation()),
                installDirUri: node_1.FileUri.create(library.getInstallDir()).toString(),
                exampleUris: library
                    .getExamplesList()
                    .map((fsPath) => node_1.FileUri.create(fsPath).toString()),
            }, library, [library.getVersion()]);
        })
            .filter(core_1.notEmpty);
    }
    mapLocation(location) {
        switch (location) {
            case lib_pb_1.LibraryLocation.LIBRARY_LOCATION_BUILTIN:
                return library_service_1.LibraryLocation.BUILTIN;
            case lib_pb_1.LibraryLocation.LIBRARY_LOCATION_USER:
                return library_service_1.LibraryLocation.USER;
            case lib_pb_1.LibraryLocation.LIBRARY_LOCATION_PLATFORM_BUILTIN:
                return library_service_1.LibraryLocation.PLATFORM_BUILTIN;
            case lib_pb_1.LibraryLocation.LIBRARY_LOCATION_REFERENCED_PLATFORM_BUILTIN:
                return library_service_1.LibraryLocation.REFERENCED_PLATFORM_BUILTIN;
            default:
                throw new Error(`Unexpected location ${location}.`);
        }
    }
    async listDependencies({ item, version, filterSelf, }) {
        const coreClient = await this.coreClient;
        const { client, instance } = coreClient;
        const req = new lib_pb_1.LibraryResolveDependenciesRequest();
        req.setInstance(instance);
        req.setName(item.name);
        req.setVersion(version);
        const dependencies = await new Promise((resolve, reject) => {
            client.libraryResolveDependencies(req, (error, resp) => {
                if (error) {
                    reject(error);
                    return;
                }
                resolve(resp.getDependenciesList().map((dep) => ({
                    name: dep.getName(),
                    installedVersion: dep.getVersionInstalled(),
                    requiredVersion: dep.getVersionRequired(),
                })));
            });
        });
        return filterSelf
            ? dependencies.filter(({ name }) => name !== item.name)
            : dependencies;
    }
    async install(options) {
        const item = options.item;
        const version = !!options.version
            ? options.version
            : item.availableVersions[0];
        const coreClient = await this.coreClient;
        const { client, instance } = coreClient;
        const req = new lib_pb_1.LibraryInstallRequest();
        req.setInstance(instance);
        req.setName(item.name);
        req.setVersion(version);
        req.setNoDeps(!options.installDependencies);
        req.setNoOverwrite(Boolean(options.noOverwrite));
        if (options.installLocation === library_service_1.LibraryLocation.BUILTIN) {
            req.setInstallLocation(lib_pb_1.LibraryInstallLocation.LIBRARY_INSTALL_LOCATION_BUILTIN);
        }
        else if (options.installLocation === library_service_1.LibraryLocation.USER) {
            req.setInstallLocation(lib_pb_1.LibraryInstallLocation.LIBRARY_INSTALL_LOCATION_USER);
        }
        console.info('>>> Starting library package installation...', item);
        // stop the board discovery
        await this.boardDiscovery.stop();
        const resp = client.libraryInstall(req);
        resp.on('data', grpc_progressible_1.ExecuteWithProgress.createDataCallback({
            progressId: options.progressId,
            responseService: this.responseService,
        }));
        await new Promise((resolve, reject) => {
            resp.on('end', () => {
                this.boardDiscovery.start(); // TODO: remove discovery dependency from boards service. See https://github.com/arduino/arduino-ide/pull/1107 why this is here.
                resolve();
            });
            resp.on('error', (error) => {
                this.responseService.appendToOutput({
                    chunk: `Failed to install library: ${item.name}${version ? `:${version}` : ''}.\n`,
                });
                this.responseService.appendToOutput({
                    chunk: `${error.toString()}\n`,
                });
                reject(error);
            });
        });
        const items = await this.search({});
        const updated = items.find((other) => library_service_1.LibraryPackage.equals(other, item)) || item;
        this.notificationServer.notifyLibraryDidInstall({ item: updated });
        console.info('<<< Library package installation done.', item);
    }
    async installZip({ zipUri, progressId, overwrite, }) {
        const coreClient = await this.coreClient;
        const { client, instance } = coreClient;
        const req = new lib_pb_1.ZipLibraryInstallRequest();
        req.setPath(node_1.FileUri.fsPath(zipUri));
        req.setInstance(instance);
        if (typeof overwrite === 'boolean') {
            req.setOverwrite(overwrite);
        }
        // stop the board discovery
        await this.boardDiscovery.stop();
        const resp = client.zipLibraryInstall(req);
        resp.on('data', grpc_progressible_1.ExecuteWithProgress.createDataCallback({
            progressId,
            responseService: this.responseService,
        }));
        await new Promise((resolve, reject) => {
            resp.on('end', () => {
                this.boardDiscovery.start(); // TODO: remove discovery dependency from boards service. See https://github.com/arduino/arduino-ide/pull/1107 why this is here.
                resolve();
            });
            resp.on('error', reject);
        });
    }
    async uninstall(options) {
        const { item, progressId } = options;
        const coreClient = await this.coreClient;
        const { client, instance } = coreClient;
        const req = new lib_pb_1.LibraryUninstallRequest();
        req.setInstance(instance);
        req.setName(item.name);
        req.setVersion(item.installedVersion);
        console.info('>>> Starting library package uninstallation...', item);
        // stop the board discovery
        await this.boardDiscovery.stop();
        const resp = client.libraryUninstall(req);
        resp.on('data', grpc_progressible_1.ExecuteWithProgress.createDataCallback({
            progressId,
            responseService: this.responseService,
        }));
        await new Promise((resolve, reject) => {
            resp.on('end', () => {
                this.boardDiscovery.start(); // TODO: remove discovery dependency from boards service. See https://github.com/arduino/arduino-ide/pull/1107 why this is here.
                resolve();
            });
            resp.on('error', reject);
        });
        this.notificationServer.notifyLibraryDidUninstall({ item });
        console.info('<<< Library package uninstallation done.', item);
    }
    dispose() {
        this.logger.info('>>> Disposing library service...');
        this.logger.info('<<< Disposed library service.');
    }
};
__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    __metadata("design:type", Object)
], LibraryServiceImpl.prototype, "logger", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ResponseService),
    __metadata("design:type", Object)
], LibraryServiceImpl.prototype, "responseService", void 0);
__decorate([
    (0, inversify_1.inject)(board_discovery_1.BoardDiscovery),
    __metadata("design:type", board_discovery_1.BoardDiscovery)
], LibraryServiceImpl.prototype, "boardDiscovery", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.NotificationServiceServer),
    __metadata("design:type", Object)
], LibraryServiceImpl.prototype, "notificationServer", void 0);
__decorate([
    (0, decorators_1.duration)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LibraryServiceImpl.prototype, "search", null);
LibraryServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], LibraryServiceImpl);
exports.LibraryServiceImpl = LibraryServiceImpl;
function toLibrary(pkg, lib, availableVersions) {
    return Object.assign(Object.assign({ name: '', label: '', exampleUris: [], installable: false, deprecated: false, location: 0 }, pkg), { author: lib.getAuthor(), availableVersions, includes: lib.getProvidesIncludesList(), description: lib.getSentence(), moreInfoLink: lib.getWebsite(), summary: lib.getParagraph(), category: lib.getCategory(), types: lib.getTypesList() });
}
//# sourceMappingURL=library-service-impl.js.map