"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitorManagerProxyImpl = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const protocol_1 = require("../common/protocol");
const monitor_manager_1 = require("./monitor-manager");
let MonitorManagerProxyImpl = class MonitorManagerProxyImpl {
    constructor(manager) {
        this.manager = manager;
    }
    dispose() {
        var _a;
        (_a = this.client) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    /**
     * Start a pluggable monitor and/or change its settings.
     * If settings are defined they'll be set before starting the monitor,
     * otherwise default ones will be used by the monitor.
     * @param board board connected to port
     * @param port port to monitor
     * @param settings map of supported configuration by the monitor
     */
    async startMonitor(board, port, settings) {
        if (settings) {
            await this.changeMonitorSettings(board, port, settings);
        }
        const connectToClient = (status) => {
            if (status === protocol_1.Status.ALREADY_CONNECTED || status === protocol_1.Status.OK) {
                // Monitor started correctly, connect it with the frontend
                this.client.connect(this.manager.getWebsocketAddressPort(board, port));
            }
        };
        return this.manager.startMonitor(board, port, connectToClient);
    }
    /**
     * Changes the settings of a running pluggable monitor, if that monitor is not
     * started this function is a noop.
     * @param board board connected to port
     * @param port port monitored
     * @param settings map of supported configuration by the monitor
     */
    async changeMonitorSettings(board, port, settings) {
        if (!this.manager.isStarted(board, port)) {
            // Monitor is not running, no need to change settings
            return;
        }
        return this.manager.changeMonitorSettings(board, port, settings);
    }
    /**
     * Stops a running pluggable monitor.
     * @param board board connected to port
     * @param port port monitored
     */
    async stopMonitor(board, port) {
        return this.manager.stopMonitor(board, port);
    }
    /**
     * Returns the current settings by the pluggable monitor connected to specified
     * by board/port combination.
     * @param board board connected to port
     * @param port port monitored
     * @returns a map of MonitorSetting
     */
    getCurrentSettings(board, port) {
        return this.manager.currentMonitorSettings(board, port);
    }
    setClient(client) {
        if (!client) {
            return;
        }
        this.client = client;
    }
};
MonitorManagerProxyImpl = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(monitor_manager_1.MonitorManager)),
    __metadata("design:paramtypes", [monitor_manager_1.MonitorManager])
], MonitorManagerProxyImpl);
exports.MonitorManagerProxyImpl = MonitorManagerProxyImpl;
//# sourceMappingURL=monitor-manager-proxy-impl.js.map