"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitorSettingsProviderImpl = void 0;
const fs = require("fs");
const path_1 = require("path");
const inversify_1 = require("inversify");
const env_variables_1 = require("@theia/core/lib/common/env-variables");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const util_1 = require("util");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
const monitor_settings_utils_1 = require("./monitor-settings-utils");
const core_1 = require("@theia/core");
const MONITOR_SETTINGS_FILE = 'pluggable-monitor-settings.json';
let MonitorSettingsProviderImpl = class MonitorSettingsProviderImpl {
    constructor() {
        // deferred used to guarantee file operations are performed after the service is initialized
        this.ready = new promise_util_1.Deferred();
    }
    async init() {
        // get the monitor settings file path
        const configDirUri = await this.envVariablesServer.getConfigDirUri();
        this.pluggableMonitorSettingsPath = (0, path_1.join)(file_uri_1.FileUri.fsPath(configDirUri), MONITOR_SETTINGS_FILE);
        // read existing settings
        await this.readSettingsFromFS();
        // init is done, resolve the deferred and unblock any call that was waiting for it
        this.ready.resolve();
    }
    async getSettings(monitorId, defaultSettings) {
        // wait for the service to complete the init
        await this.ready.promise;
        const { matchingSettings } = this.longestPrefixMatch(monitorId);
        this.monitorSettings[monitorId] = this.reconcileSettings(matchingSettings, defaultSettings);
        return this.monitorSettings[monitorId];
    }
    async setSettings(monitorId, settings) {
        // wait for the service to complete the init
        await this.ready.promise;
        const newSettings = this.reconcileSettings(settings, this.monitorSettings[monitorId] || {});
        this.monitorSettings[monitorId] = newSettings;
        await this.writeSettingsToFS();
        return newSettings;
    }
    reconcileSettings(newSettings, defaultSettings) {
        return (0, monitor_settings_utils_1.reconcileSettings)(newSettings, defaultSettings);
    }
    async readSettingsFromFS() {
        const rawJson = await (0, util_1.promisify)(fs.readFile)(this.pluggableMonitorSettingsPath, {
            encoding: 'utf-8',
            flag: 'a+', // a+ = append and read, creating the file if it doesn't exist
        });
        if (!rawJson) {
            this.monitorSettings = {};
        }
        try {
            this.monitorSettings = JSON.parse(rawJson);
        }
        catch (error) {
            this.logger.error('Could not parse the pluggable monitor settings file. Using empty file.');
            this.monitorSettings = {};
        }
    }
    async writeSettingsToFS() {
        await (0, util_1.promisify)(fs.writeFile)(this.pluggableMonitorSettingsPath, JSON.stringify(this.monitorSettings));
    }
    longestPrefixMatch(id) {
        return (0, monitor_settings_utils_1.longestPrefixMatch)(id, this.monitorSettings);
    }
};
__decorate([
    (0, inversify_1.inject)(env_variables_1.EnvVariablesServer),
    __metadata("design:type", Object)
], MonitorSettingsProviderImpl.prototype, "envVariablesServer", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    __metadata("design:type", Object)
], MonitorSettingsProviderImpl.prototype, "logger", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MonitorSettingsProviderImpl.prototype, "init", null);
MonitorSettingsProviderImpl = __decorate([
    (0, inversify_1.injectable)()
], MonitorSettingsProviderImpl);
exports.MonitorSettingsProviderImpl = MonitorSettingsProviderImpl;
//# sourceMappingURL=monitor-settings-provider-impl.js.map