"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationServiceServerImpl = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
let NotificationServiceServerImpl = class NotificationServiceServerImpl {
    constructor() {
        this.clients = [];
    }
    notifyIndexWillUpdate(progressId) {
        this.clients.forEach((client) => client.notifyIndexWillUpdate(progressId));
    }
    notifyIndexUpdateDidProgress(progressMessage) {
        this.clients.forEach((client) => client.notifyIndexUpdateDidProgress(progressMessage));
    }
    notifyIndexDidUpdate(progressId) {
        this.clients.forEach((client) => client.notifyIndexDidUpdate(progressId));
    }
    notifyIndexUpdateDidFail({ progressId, message, }) {
        this.clients.forEach((client) => client.notifyIndexUpdateDidFail({ progressId, message }));
    }
    notifyDaemonDidStart(port) {
        this.clients.forEach((client) => client.notifyDaemonDidStart(port));
    }
    notifyDaemonDidStop() {
        this.clients.forEach((client) => client.notifyDaemonDidStop());
    }
    notifyPlatformDidInstall(event) {
        this.clients.forEach((client) => client.notifyPlatformDidInstall(event));
    }
    notifyPlatformDidUninstall(event) {
        this.clients.forEach((client) => client.notifyPlatformDidUninstall(event));
    }
    notifyLibraryDidInstall(event) {
        this.clients.forEach((client) => client.notifyLibraryDidInstall(event));
    }
    notifyLibraryDidUninstall(event) {
        this.clients.forEach((client) => client.notifyLibraryDidUninstall(event));
    }
    notifyAttachedBoardsDidChange(event) {
        this.clients.forEach((client) => client.notifyAttachedBoardsDidChange(event));
    }
    notifyConfigDidChange(event) {
        this.clients.forEach((client) => client.notifyConfigDidChange(event));
    }
    notifyRecentSketchesDidChange(event) {
        this.clients.forEach((client) => client.notifyRecentSketchesDidChange(event));
    }
    setClient(client) {
        this.clients.push(client);
    }
    disposeClient(client) {
        const index = this.clients.indexOf(client);
        if (index === -1) {
            console.warn('Could not dispose notification service client. It was not registered.');
            return;
        }
        this.clients.splice(index, 1);
    }
    dispose() {
        for (const client of this.clients) {
            this.disposeClient(client);
        }
        this.clients.length = 0;
    }
};
NotificationServiceServerImpl = __decorate([
    (0, inversify_1.injectable)()
], NotificationServiceServerImpl);
exports.NotificationServiceServerImpl = NotificationServiceServerImpl;
//# sourceMappingURL=notification-service-server.js.map