"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceError = void 0;
const grpc_js_1 = require("@grpc/grpc-js");
var ServiceError;
(function (ServiceError) {
    function isCancel(arg) {
        return is(arg) && arg.code === 1; // https://grpc.github.io/grpc/core/md_doc_statuscodes.html
    }
    ServiceError.isCancel = isCancel;
    function is(arg) {
        return arg instanceof Error && isStatusObjet(arg);
    }
    ServiceError.is = is;
    function isStatusObjet(arg) {
        if (typeof arg === 'object') {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const any = arg;
            return (!!arg &&
                'code' in arg &&
                'details' in arg &&
                typeof any.details === 'string' &&
                'metadata' in arg &&
                any.metadata instanceof grpc_js_1.Metadata);
        }
        return false;
    }
})(ServiceError = exports.ServiceError || (exports.ServiceError = {}));
//# sourceMappingURL=service-error.js.map