"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultWorkspaceServer = void 0;
const fs_1 = require("fs");
const inversify_1 = require("@theia/core/shared/inversify");
const default_workspace_server_1 = require("@theia/workspace/lib/node/default-workspace-server");
const protocol_1 = require("../../../common/protocol");
const node_1 = require("@theia/core/lib/node");
const is_temp_sketch_1 = require("../../is-temp-sketch");
let DefaultWorkspaceServer = class DefaultWorkspaceServer extends default_workspace_server_1.DefaultWorkspaceServer {
    async getMostRecentlyUsedWorkspace() {
        const uri = await super.getMostRecentlyUsedWorkspace();
        if (!uri) {
            const { uri } = await this.sketchesService.createNewSketch();
            return uri;
        }
        return uri;
    }
    /**
     * This is the async re-implementation of the default Theia behavior.
     */
    async getRecentWorkspaces() {
        const listUri = [];
        const data = await this.readRecentWorkspacePathsFromUserHome();
        if (data && data.recentRoots) {
            await Promise.all(data.recentRoots
                .filter((element) => Boolean(element))
                .map(async (element) => {
                if (await this.exists(element)) {
                    listUri.push(element);
                }
            }));
        }
        return listUri;
    }
    async writeToUserHome(data) {
        return super.writeToUserHome(this.filterTempSketches(data));
    }
    async readRecentWorkspacePathsFromUserHome() {
        const data = await super.readRecentWorkspacePathsFromUserHome();
        return data ? this.filterTempSketches(data) : undefined;
    }
    async removeOldUntitledWorkspaces() {
        // NOOP
        // No need to remove untitled workspaces. IDE2 does not use workspaces.
    }
    filterTempSketches(data) {
        const recentRoots = data.recentRoots.filter((uri) => !this.isTempSketch.is(node_1.FileUri.fsPath(uri)));
        return {
            recentRoots,
        };
    }
    async exists(uri) {
        try {
            await fs_1.promises.access(node_1.FileUri.fsPath(uri), fs_1.constants.R_OK | fs_1.constants.W_OK);
            return true;
        }
        catch (_a) {
            return false;
        }
    }
};
__decorate([
    (0, inversify_1.inject)(protocol_1.SketchesService),
    __metadata("design:type", Object)
], DefaultWorkspaceServer.prototype, "sketchesService", void 0);
__decorate([
    (0, inversify_1.inject)(is_temp_sketch_1.IsTempSketch),
    __metadata("design:type", is_temp_sketch_1.IsTempSketch)
], DefaultWorkspaceServer.prototype, "isTempSketch", void 0);
DefaultWorkspaceServer = __decorate([
    (0, inversify_1.injectable)()
], DefaultWorkspaceServer);
exports.DefaultWorkspaceServer = DefaultWorkspaceServer;
//# sourceMappingURL=default-workspace-server.js.map