"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoFlushingBuffer = void 0;
const core_1 = require("@theia/core");
const vscode_languageserver_protocol_1 = require("@theia/core/shared/vscode-languageserver-protocol");
const protocol_1 = require("../../common/protocol");
class AutoFlushingBuffer {
    constructor(onFlush, taskTimeout = AutoFlushingBuffer.DEFAULT_FLUSH_TIMEOUT_MS) {
        this.chunks = [];
        this.disposed = false;
        const task = () => {
            if (!Chunks.isEmpty(this.chunks)) {
                const chunks = Chunks.toString(this.chunks);
                Chunks.clear(this.chunks);
                onFlush(chunks);
            }
            if (!this.disposed) {
                this.timer = setTimeout(task, taskTimeout);
            }
        };
        this.timer = setTimeout(task, taskTimeout);
        this.toDispose = new core_1.DisposableCollection(vscode_languageserver_protocol_1.Disposable.create(() => (this.disposed = true)), vscode_languageserver_protocol_1.Disposable.create(() => clearTimeout(this.timer)), vscode_languageserver_protocol_1.Disposable.create(() => task()));
    }
    addChunk(chunk, severity = protocol_1.OutputMessage.Severity.Info) {
        if (chunk.length) {
            this.chunks.push([severity, chunk]);
        }
    }
    dispose() {
        this.toDispose.dispose();
    }
}
exports.AutoFlushingBuffer = AutoFlushingBuffer;
(function (AutoFlushingBuffer) {
    /**
     * _"chunking and sending every 16ms (60hz) is the best for small amount of data
     * To be able to crunch more data without the cpu going to high, I opted for a 30fps refresh rate, hence the 32msec"_
     */
    AutoFlushingBuffer.DEFAULT_FLUSH_TIMEOUT_MS = 32;
})(AutoFlushingBuffer = exports.AutoFlushingBuffer || (exports.AutoFlushingBuffer = {}));
var Chunks;
(function (Chunks) {
    function clear(chunks) {
        chunks.length = 0;
        return chunks;
    }
    Chunks.clear = clear;
    function isEmpty(chunks) {
        return ![...chunks.values()].some((chunk) => Boolean(chunk.length));
    }
    Chunks.isEmpty = isEmpty;
    function toString(chunks) {
        const result = [];
        let current = undefined;
        const appendToResult = () => {
            if (current && current.buffers) {
                result.push([
                    current.severity,
                    Buffer.concat(current.buffers).toString('utf-8'),
                ]);
            }
        };
        for (const [severity, buffer] of chunks) {
            if (!buffer.length) {
                continue;
            }
            if (!current) {
                current = { severity, buffers: [buffer] };
            }
            else {
                if (current.severity === severity) {
                    current.buffers.push(buffer);
                }
                else {
                    appendToResult();
                    current = { severity, buffers: [buffer] };
                }
            }
        }
        appendToResult();
        return result;
    }
    Chunks.toString = toString;
})(Chunks || (Chunks = {}));
//# sourceMappingURL=buffers.js.map