"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const protocol_1 = require("../../common/protocol");
describe('config-service', () => {
    describe('additionalUrls', () => {
        it('should consider additional URLs same as if they differ in case', () => {
            (0, chai_1.expect)(protocol_1.AdditionalUrls.sameAs(['aaaa'], ['AAAA'])).to.be.true;
        });
        it('should consider additional URLs same as if they have a different order', () => {
            (0, chai_1.expect)(protocol_1.AdditionalUrls.sameAs(['bbbb', 'aaaa'], ['aaaa', 'bbbb'])).to.be
                .true;
        });
        it('should parse an empty string as an empty array', () => {
            (0, chai_1.expect)(protocol_1.AdditionalUrls.parse('', ',')).to.be.empty;
        });
        it('should parse a blank string as an empty array', () => {
            (0, chai_1.expect)(protocol_1.AdditionalUrls.parse('   ', ',')).to.be.empty;
        });
        it('should parse urls with commas', () => {
            (0, chai_1.expect)(protocol_1.AdditionalUrls.parse('  ,a  , b , c,   ', ',')).to.be.deep.equal([
                'a',
                'b',
                'c',
            ]);
        });
        it("should parse urls with both '\\n' and '\\r\\n' line endings", () => {
            (0, chai_1.expect)(protocol_1.AdditionalUrls.parse('a ' + '\r\n' + '   b ' + '\n' + '   c ' + '\r\n' + '  ' + '\n' + '', 'newline')).to.be.deep.equal(['a', 'b', 'c']);
        });
    });
});
//# sourceMappingURL=config-service.test.js.map