"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
// import * as net from 'net';
const path = require("path");
const temp = require("temp");
const chai_1 = require("chai");
const js_yaml_1 = require("js-yaml");
const arduino_daemon_impl_1 = require("../../node/arduino-daemon-impl");
const exec_util_1 = require("../../node/exec-util");
const cli_config_1 = require("../../node/cli-config");
const track = temp.track();
class SilentArduinoDaemonImpl extends arduino_daemon_impl_1.ArduinoDaemonImpl {
    constructor(logFormat) {
        super();
        this.logFormat = logFormat;
    }
    onData(data) {
        // NOOP
    }
    async spawnDaemonProcess() {
        return super.spawnDaemonProcess();
    }
    async getSpawnArgs() {
        const cliConfigPath = await this.initCliConfig();
        return [
            'daemon',
            '--format',
            'jsonmini',
            '--port',
            '0',
            '--config-file',
            cliConfigPath,
            '-v',
            '--log-format',
            this.logFormat,
        ];
    }
    async initCliConfig() {
        const cliPath = await this.getExecPath();
        const destDir = track.mkdirSync();
        await (0, exec_util_1.spawnCommand)(`"${cliPath}"`, [
            'config',
            'init',
            '--dest-dir',
            destDir,
        ]);
        const content = fs.readFileSync(path.join(destDir, cli_config_1.CLI_CONFIG), {
            encoding: 'utf8',
        });
        const cliConfig = (0, js_yaml_1.safeLoad)(content);
        // cliConfig.daemon.port = String(this.port);
        const modifiedContent = (0, js_yaml_1.safeDump)(cliConfig);
        fs.writeFileSync(path.join(destDir, cli_config_1.CLI_CONFIG), modifiedContent, {
            encoding: 'utf8',
        });
        return path.join(destDir, cli_config_1.CLI_CONFIG);
    }
}
describe('arduino-daemon-impl', () => {
    after(() => {
        track.cleanupSync();
    });
    it('should parse the port address when the log format is json', async () => {
        const { daemon, port } = await new SilentArduinoDaemonImpl('json').spawnDaemonProcess();
        (0, chai_1.expect)(port).not.to.be.undefined;
        (0, chai_1.expect)(port).not.to.be.equal('0');
        daemon.kill();
    });
    it('should parse the port address when the log format is text', async () => {
        const { daemon, port } = await new SilentArduinoDaemonImpl('text').spawnDaemonProcess();
        (0, chai_1.expect)(port).not.to.be.undefined;
        (0, chai_1.expect)(port).not.to.be.equal('0');
        daemon.kill();
    });
});
//# sourceMappingURL=arduino-daemon-impl.test.js.map