"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const cli_config_1 = require("../../node/cli-config");
describe('cli-config', () => {
    [
        [defaultConfig, defaultConfig, true],
        [
            () => {
                const conf = defaultConfig();
                delete conf.board_manager;
                return conf;
            },
            defaultConfig,
            true,
        ],
        [
            () => {
                const conf = defaultConfig();
                return conf;
            },
            defaultConfig,
            true,
        ],
    ].forEach(([leftInput, rightInput, expectation]) => {
        const left = typeof leftInput === 'function' ? leftInput() : leftInput;
        const right = typeof rightInput === 'function' ? rightInput() : rightInput;
        it(`${JSON.stringify(left)} should ${expectation ? '' : 'not '}be the same as ${JSON.stringify(right)}`, () => {
            (0, chai_1.expect)(cli_config_1.DefaultCliConfig.sameAs(left, right)).to.be.equal(expectation);
        });
    });
    function defaultConfig() {
        return {
            board_manager: {
                additional_urls: [],
            },
            directories: {
                data: 'data',
                user: 'user',
            },
        };
    }
});
//# sourceMappingURL=cli-config.test.js.map