import { createContext, useContext, createElement } from 'react';

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

var DisabledContext =
/*#__PURE__*/
createContext(false);
var Disable = function Disable(_ref) {
  var children = _ref.children,
      _ref$as = _ref.as,
      as = _ref$as === void 0 ? 'div' : _ref$as,
      _ref$disabledOpacity = _ref.disabledOpacity,
      disabledOpacity = _ref$disabledOpacity === void 0 ? 0.3 : _ref$disabledOpacity,
      disabledStyles = _ref.disabledStyles,
      disabled = _ref.disabled,
      rest = _objectWithoutPropertiesLoose(_ref, ["children", "as", "disabledOpacity", "disabledStyles", "disabled"]);

  var disableEvent = function disableEvent(e) {
    if (disabled) {
      e.preventDefault();
      e.stopPropagation();
    }
  };

  var isParentDisabled = useContext(DisabledContext);
  var shouldDisable = isParentDisabled ? false : disabled;
  return createElement(DisabledContext.Provider, {
    value: disabled
  }, createElement(as, _extends({
    style: _extends({
      transition: 'all 100ms linear'
    }, shouldDisable && _extends({
      opacity: disabledOpacity,
      pointerEvents: 'none'
    }, disabledStyles))
  }, shouldDisable && {
    tabIndex: -1
  }, {
    onKeyDown: disableEvent,
    onClick: disableEvent,
    disabled: shouldDisable
  }, rest), children));
};

export { Disable, DisabledContext };
//# sourceMappingURL=react-disable.esm.js.map
